// This file was automatically generated by shadergen. Do not edit by hand!

static char pshader_basic_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char pshader_basic_frag1[] = "";
static char pshader_basic_frag2[] =
   "COMMON_PSCONSTANTS;\n"
   "\n"
   "#ifdef TEX0\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex0, 0);\n"
   "#endif\n"
   "\n"
   "#ifndef READ_ALPHA_TEX\n"
   "#define READ_ALPHA_TEX(x) ((x).a)\n"
   "#endif\n"
   "\n"
   "#ifndef AATEX_USE_SAMPLER1\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex1, 7);\n"
   "#else\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex1, 1);\n"
   "#endif\n"
   "\n"
   "MAIN((ARGS))\n"
   "{\n"
   "   LOWP VEC4 z;\n"
   "   MEDIUMP VEC4 t;\n"
   "   \n"
   "   z = color_mul;\n"
   "   \n"
   "   #ifndef ADDITIVE_ALPHA\n"
   "   z.rgb *= z.a; // premultiply; could do outside\n"
   "   #endif\n"
   "   \n"
   "   #ifdef TEX0\n"
   "      MEDIUMP VEC2 c,tc0;\n"
   "      tc0 = TC0;\n"
   "\n"
   "      #ifdef EXPLICIT_PROJECTION\n"
   "      float one_over_w = 1.0 / TC1.y;\n"
   "      tc0.x *= one_over_w;\n"
   "      tc0.y *= one_over_w;\n"
   "      #endif\n"
   "      \n"
   "      #ifdef TEX0_RADIAL\n"
   "         tc0.x = sqrt(dot(tc0.xy,tc0.xy));\n"
   "         tc0.y = tc0.x; // necessary on some OpenGL devices\n"
   "      #else\n"
   "      #ifdef TEX0_FOCAL\n"
   "         c.x = tc0.x + focal.x;\n"
   "         c.y = tc0.y;\n"
   "         t.x = c.x * focal.y;\n"
   "         t.y = (c.x*c.x + c.y*c.y) * focal.z;\n"
   "         tc0.x = sqrt(t.y + t.x*t.x) - t.x;\n"
   "         tc0.y = tc0.x;\n"
   "      #endif\n"
   "      #endif\n"
   "\n"
   "      #ifdef TEX0_ALPHA\n"
   "         t.a = READ_ALPHA_TEX(TEX2D(tex0, tc0));\n"
   "         #ifdef ADDITIVE_ALPHA\n"
   "            z.a *= t.a;\n"
   "         #else\n"
   "            z *= t.a;\n"
   "         #endif\n"
   "      #else\n"
   "         t = TEX2D(tex0, tc0);\n"
   "         #ifdef ADDITIVE_ALPHA\n"
   "            if (t.a != 0.0) t.rgb = t.rgb * (1.0/t.a); // unpremultiply\n"
   "         #endif\n"
   "         z *= t;\n"
   "      #endif\n"
   "   #endif\n"
   "\n"
   "   MEDIUMP VEC2 tc1;\n"
   "   tc1.xy = TC1.xy;\n"
   "\n"
   "   #ifdef EXPLICIT_PROJECTION\n"
   "   tc1.x /= TC1.y;\n"
   "   #endif\n"
   "\n"
   "   // antialiasing blend curve\n"
   "   t = TEX2D(tex1, tc1.xy);\n"
   "   #ifdef ADDITIVE_ALPHA\n"
   "      z.a *= t.a;\n"
   "   #else\n"
   "      z *= t;\n"
   "   #endif\n"
   "\n"
   "   #ifdef ADDITIVE_ALPHA\n"
   "      z += color_add;\n"
   "      z.rgb *= z.a; // premultiply\n"
   "   #else\n"
   "   #ifdef ADDITIVE\n"
   "      z.rgb += color_add.rgb * z.a; // scale addend to match premultiply\n"
   "      z.rgb = min(z.rgb, z.a);\n"
   "   #endif\n"
   "   #endif\n"
   "   \n"
   "   #ifdef TEX0_ALPHA_TEST\n"
   "   SHADER_ALPHATEST(z.a);\n"
   "   #endif\n"
   "\n"
   "   OUTPUT(z);\n"
   "}\n";
static char pshader_basic_frag3[] =
   "#define ADDITIVE\n";
static char pshader_basic_frag4[] =
   "#define ADDITIVE_ALPHA\n";
static char pshader_basic_frag5[] =
   "#define TEX0\n";
static char pshader_basic_frag6[] =
   "#define TEX0\n"
   "#define TEX0_ALPHA\n";
static char pshader_basic_frag7[] =
   "#define TEX0\n"
   "#define TEX0_RADIAL\n";
static char pshader_basic_frag8[] =
   "#define TEX0\n"
   "#define TEX0_FOCAL\n";
static char pshader_basic_frag9[] =
   "#define TEX0\n"
   "#define TEX0_ALPHA\n"
   "#define TEX0_ALPHA_TEST\n";

#define NUMFRAGMENTS_pshader_basic 4
static char *pshader_basic_arr[18][NUMFRAGMENTS_pshader_basic] = {
   { pshader_basic_frag0, pshader_basic_frag1, pshader_basic_frag1, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag1, pshader_basic_frag3, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag1, pshader_basic_frag4, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag5, pshader_basic_frag1, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag5, pshader_basic_frag3, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag5, pshader_basic_frag4, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag6, pshader_basic_frag1, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag6, pshader_basic_frag3, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag6, pshader_basic_frag4, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag7, pshader_basic_frag1, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag7, pshader_basic_frag3, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag7, pshader_basic_frag4, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag8, pshader_basic_frag1, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag8, pshader_basic_frag3, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag8, pshader_basic_frag4, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag9, pshader_basic_frag1, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag9, pshader_basic_frag3, pshader_basic_frag2, },
   { pshader_basic_frag0, pshader_basic_frag9, pshader_basic_frag4, pshader_basic_frag2, },
};

static char **pshader_basic(int tex0, int additive)
{
   return pshader_basic_arr[0 + tex0*3 + additive*1];
}

static char *pshader_basic_vars[] = {
   "tex0",
   "tex1",
   "color_mul",
   "color_add",
   "focal",
   NULL
};

static char pshader_general2_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char pshader_general2_frag1[] =
   "COMMON_PCONSTANTS2\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex0, 0);\n"
   "MAIN((ARGS2))\n"
   "{\n"
   "   // get t, the basic texture color\n"
   "\n"
   "   LOWP VEC4 t;\n"
   "   \n"
   "   t = TEX2D(tex0, tex_coord.xy);\n"
   "\n"
   "   // now color-transform t\n"
   "   //\n"
   "   // to determine optimal format for vertex shader to output the color, let's\n"
   "   // start by doing the math assuming the texture is premultiplied, but not\n"
   "   // the color transform:\n"
   "   //\n"
   "   //       out.r = (tex.r * color_mul.r * color_mul.a) + (color_add.r * tex.a * color_mul.a)\n"
   "   //       out.a = tex.a * color_mul.a * color_add.a // color_add.a is blend mode emulation\n"
   "   //\n"
   "   // now, we can see in the above we can premultiply both mul and add by color_mul.a\n"
   "   //\n"
   "   //       out.r = (tex.r * color_mulp.r) + (color_addp.r * tex.a)\n"
   "   //       out.a = tex.a * color_mulp.a // can premultiply color_add.a here as well\n"
   "\n"
   "   \n"
   "   LOWP VEC4 c;\n"
   "   c.rgb = t.rgb * color_mul.rgb + t.a * color_add.rgb;\n"
   "   c.a   = t.a   * color_mul.a;\n"
   "\n"
   "   // apply clip rect\n"
   "   //\n"
   "   //   naive math, using panel-space coordinates\n"
   "   //\n"
   "   //       panel_offset = abs(pos-center) - half_width\n"
   "   //\n"
   "   //   Above function is negative where not clipped, positive\n"
   "   //   where clipped. Now, we want to capture a one-pixel boundary,\n"
   "   //   so we need to go to pixel coordinates:\n"
   "   //\n"
   "   //       panel_offset *= pixels_per_panel_unit;\n"
   "   //       // note this doesn't account for non-uniform scale of panel\n"
   "   //\n"
   "   //   And now, with an offset in pixels, we want to compute an AA mask:\n"
   "   //\n"
   "   //       saturate(1-panel_offset)\n"
   "   //\n"
   "   //   Note that we can just multiply pixels_per_panel_unit into\n"
   "   //   each of the terms in panel offset, and we're left with:\n"
   "   //\n"
   "   //       saturate(1 - (abs() - k))\n"
   "   //\n"
   "   //   which becomes:\n"
   "   //\n"
   "   //       saturate(k+1 - abs())\n"
   "   //\n"
   "   //   and the +1 is folded into k.\n"
   "\n"
   "   LOWP VEC2 cliprect_alpha = saturate(clip_rect.zw - abs(tex_coord.zw - clip_rect.xy));\n"
   "\n"
   "   float edge_alpha = cliprect_alpha.x * cliprect_alpha.y;\n"
   "   // could be min, but multiply represents coverage better in theory; @TODO check visually\n"
   "\n"
   "   // multiply it into c's alpha, but c's already premultiplied so multiply it all\n"
   "   c *= edge_alpha;\n"
   "\n"
   "   OUTPUT(c);\n"
   "}\n";

#define NUMFRAGMENTS_pshader_general2 2
static char *pshader_general2_arr[1][NUMFRAGMENTS_pshader_general2] = {
   { pshader_general2_frag0, pshader_general2_frag1, },
};

static char **pshader_general2(void)
{
   return pshader_general2_arr[0];
}

static char *pshader_general2_vars[] = {
   "tex0",
   NULL
};

static char pshader_exceptional_blend_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char pshader_exceptional_blend_frag1[] =
   "#define BLENDPROG return s*d;\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag2[] =
   "#define TEX0\n"
   "\n"
   "MEDIUMP float compute(MEDIUMP float s, MEDIUMP float sa, MEDIUMP float d, MEDIUMP float da)\n"
   "{\n"
   "    BLENDPROG\n"
   "}\n"
   "\n"
   "MEDIUMP float compute_a(MEDIUMP float sa, MEDIUMP float da)\n"
   "{\n"
   "    ALPHAFUNC\n"
   "}\n"
   "\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex0, 0);\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex1, 1);\n"
   "COMMON_PSCONSTANTS;\n"
   "\n"
   "MAIN((ARGS))\n"
   "{\n"
   "    MEDIUMP VEC4 srcc,dstc;\n"
   "    MEDIUMP VEC3 mixed;\n"
   "    MEDIUMP VEC2 tc;\n"
   "    srcc = TEX2D(tex0, TC0.xy);\n"
   "    srcc = srcc*VEC4(color_mul.rgb, 1.0)*color_mul.a + color_add*srcc.a;\n"
   "    srcc = clamp(srcc,VEC4(0.0,0.0,0.0,0.0),VEC4(1.0,1.0,1.0,1.0));\n"
   "    tc = TC0.xy;\n"
   "    #ifndef EXCEPTIONAL_BLEND_LOAD\n"
   "        #ifndef EXCEPTIONAL_BLEND_RESCALE\n"
   "            dstc = TEX2D(tex1, tc).rgba;\n"
   "        #else\n"
   "            dstc = TEX2D(tex1, tc*rescale1.xy + rescale1.zw).rgba;\n"
   "        #endif\n"
   "    #else\n"
   "        dstc = EXCEPTIONAL_BLEND_LOAD(tex1, tc);\n"
   "    #endif\n"
   "    mixed.r = compute(srcc.r,srcc.a, dstc.r,dstc.a);\n"
   "    mixed.g = compute(srcc.g,srcc.a, dstc.g,dstc.a);\n"
   "    mixed.b = compute(srcc.b,srcc.a, dstc.b,dstc.a);\n"
   "    MEDIUMP VEC4 res;\n"
   "    #ifdef DIRECT\n"
   "        res.rgb = mixed;\n"
   "    #else\n"
   "        res.rgb = mixed + (1.0-srcc.a)*dstc.rgb + (1.0-dstc.a)*srcc.rgb;\n"
   "    #endif\n"
   "    res.a = compute_a(srcc.a,dstc.a);\n"
   "    OUTPUT(res);\n"
   "}\n";
static char pshader_exceptional_blend_frag3[] =
   "#define BLENDPROG return sa*da - (da-d)*(sa-s);\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag4[] =
   "#define BLENDPROG return max(sa*d,s*da);\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag5[] =
   "#define BLENDPROG return min(sa*d,s*da);\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag6[] =
   "#define DIRECT\n"
   "#define BLENDPROG return min(d+s,1.0);\n"
   "#define ALPHAFUNC return min(sa+da,1.0);\n";
static char pshader_exceptional_blend_frag7[] =
   "#define DIRECT\n"
   "#define BLENDPROG return max(d-s,0.0);\n"
   "#define ALPHAFUNC return min(sa+da,1.0);\n";
static char pshader_exceptional_blend_frag8[] =
   "#define BLENDPROG return abs(sa*d-s*da);\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag9[] =
   "#define BLENDPROG return sa*(da-d);\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag10[] =
   "#define BLENDPROG return d < da/2.0 ? (2.0*s*d) : (sa*da - 2.0*(da-d)*(sa-s));\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag11[] =
   "#define BLENDPROG return s < sa/2.0 ? (2.0*s*d) : (sa*da - 2.0*(da-d)*(sa-s));\n"
   "#define ALPHAFUNC return sa+da-sa*da;\n";
static char pshader_exceptional_blend_frag12[] =
   "#define DIRECT\n"
   "#define BLENDPROG return d*(1.0-sa);\n"
   "#define ALPHAFUNC return (1.0-sa)*da;\n";
static char pshader_exceptional_blend_frag13[] =
   "#define DIRECT\n"
   "#define BLENDPROG return d*sa;\n"
   "#define ALPHAFUNC return sa*da;\n";

#define NUMFRAGMENTS_pshader_exceptional_blend 3
static char *pshader_exceptional_blend_arr[13][NUMFRAGMENTS_pshader_exceptional_blend] = {
   { NULL, NULL, NULL, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag1, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag3, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag4, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag5, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag6, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag7, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag8, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag9, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag10, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag11, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag12, pshader_exceptional_blend_frag2, },
   { pshader_exceptional_blend_frag0, pshader_exceptional_blend_frag13, pshader_exceptional_blend_frag2, },
};

static char **pshader_exceptional_blend(int blend_mode)
{
   return pshader_exceptional_blend_arr[0 + blend_mode*1];
}

static char *pshader_exceptional_blend_vars[] = {
   "tex0",
   "tex1",
   "color_mul",
   "color_add",
   NULL
};

static char pshader_filter_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char pshader_filter_frag1[] = "";
static char pshader_filter_frag2[] =
   "#define TEX0\n"
   "\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex0, 0);\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex1, 1);\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex2, 2);\n"
   "\n"
   "COMMON_PSCONSTANTS;\n"
   "\n"
   "BEGIN_CONSTANTS        \n"
   "    DECLARE_CONST_EXTRA(HIGHP VEC4, clamp0, 4);\n"
   "    DECLARE_CONST_EXTRA(HIGHP VEC4, clamp1, 5);\n"
   "    #define CLAMP(a,b) clamp(a.xy, b.xy, b.zw)\n"
   "\n"
   "    DECLARE_CONST_EXTRA(LOWP VEC4, color, 6);\n"
   "    DECLARE_CONST_EXTRA(LOWP VEC4, color2, 7);\n"
   "    DECLARE_CONST_EXTRA(MEDIUMP VEC4, tc_off, 8);\n"
   "END_CONSTANTS\n"
   "    \n"
   "MAIN((ARGS))\n"
   "{\n"
   "    LOWP VEC4 source;\n"
   "    source = TEX2D(tex1, CLAMP(TC0.xy,clamp1));\n"
   "    MEDIUMP float shadow_a = TEX2D(tex0, CLAMP(TC0.xy + tc_off.xy,clamp0)).a;\n"
   "    \n"
   "    #ifdef BEVEL\n"
   "    MEDIUMP float shadow_b = TEX2D(tex0, CLAMP(TC0.xy - tc_off.xy,clamp0)).a;\n"
   "    shadow_a = (shadow_b - shadow_a) * tc_off.z;\n"
   "    #ifdef GRADIENT\n"
   "        shadow_a = clamp(shadow_a*0.5 + 0.5, 0.0, 1.0);\n"
   "    #else\n"
   "        shadow_b = clamp(-shadow_a, 0.0, 1.0);\n"
   "        shadow_a = clamp(shadow_a, 0.0, 1.0);\n"
   "    #endif\n"
   "    #else\n"
   "    #ifdef INNER\n"
   "        #ifndef GRADIENT\n"
   "            shadow_a = 1.0-shadow_a;\n"
   "        #endif // !GRADIENT\n"
   "    #endif // INNER\n"
   "    shadow_a = min(shadow_a*tc_off.z,1.0);\n"
   "    #endif // BEVEL\n"
   "    \n"
   "    #ifdef GRADIENT\n"
   "        MEDIUMP VEC2 gtc = VEC2(shadow_a, 0.5);\n"
   "        MEDIUMP VEC4 ecolor = TEX2D(tex2, gtc);\n"
   "        shadow_a = 1.0;\n"
   "    #else\n"
   "    #ifdef BEVEL\n"
   "        MEDIUMP VEC4 ecolor = shadow_b*color + shadow_a*color2;\n"
   "        shadow_a = 1.0;\n"
   "    #else\n"
   "        MEDIUMP VEC4 ecolor = color;\n"
   "    #endif\n"
   "    #endif\n"
   "    \n"
   "    #ifdef ONTOP\n"
   "    #ifdef KNOCKOUT\n"
   "    OUTPUT(ecolor);\n"
   "    #else\n"
   "    OUTPUT(ecolor + source * (1.0-ecolor.a));\n"
   "    #endif\n"
   "    #else\n"
   "    \n"
   "    #ifdef KNOCKOUT\n"
   "    #ifdef INNER\n"
   "    // KNOCKOUT & INNER\n"
   "    OUTPUT(ecolor * source.a * shadow_a);\n"
   "    #else\n"
   "    // KNOCKOUT & !INNER\n"
   "    OUTPUT(ecolor * (1.0-source.a) * shadow_a);\n"
   "    #endif\n"
   "    #else // !KNOCKOUT\n"
   "    \n"
   "    #ifdef INNER\n"
   "    // !KNOCKOUT & INNER\n"
   "    /* this is particularly subtle; effectively computes\n"
   "        invert shadow\n"
   "        unpremultiply source\n"
   "        shadow*color over source.rgb (treat as opaque)\n"
   "        multiply through by source alpha (i.e. make premultiplied again)\n"
   "      but expressed without *actually* unpremultiplying\n"
   "    */\n"
   "    LOWP VEC4 shadow = ecolor * shadow_a;\n"
   "    LOWP VEC4 res;\n"
   "    res.rgb = shadow.rgb*source.a + source.rgb*(1.0-shadow.a);\n"
   "    res.a = source.a;\n"
   "    OUTPUT(res);\n"
   "    #else\n"
   "    // !KNOCKOUT & !INNER\n"
   "    LOWP VEC4 shadow = ecolor * shadow_a;\n"
   "    OUTPUT(shadow * (1.0-source.a) + source);\n"
   "    #endif // INNER\n"
   "\n"
   "    #endif // KNOCKOUT\n"
   "    #endif // ONTOP\n"
   "}\n";
static char pshader_filter_frag3[] =
   "#define KNOCKOUT\n";
static char pshader_filter_frag4[] =
   "#define GRADIENT\n";
static char pshader_filter_frag5[] =
   "#define INNER\n";
static char pshader_filter_frag6[] =
   "#define ONTOP\n";
static char pshader_filter_frag7[] =
   "#define BEVEL\n";

#define NUMFRAGMENTS_pshader_filter 7
static char *pshader_filter_arr[32][NUMFRAGMENTS_pshader_filter] = {
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag1, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag4, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag4, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag1, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag3, pshader_filter_frag2, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag1, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag4, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag1, pshader_filter_frag5, pshader_filter_frag4, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag1, pshader_filter_frag3, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag1, pshader_filter_frag2, },
   { pshader_filter_frag0, pshader_filter_frag7, pshader_filter_frag6, pshader_filter_frag1, pshader_filter_frag4, pshader_filter_frag3, pshader_filter_frag2, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
   { NULL, NULL, NULL, NULL, NULL, NULL, NULL, },
};

static char **pshader_filter(int bevel, int ontop, int inner, int gradient, int knockout)
{
   return pshader_filter_arr[0 + bevel*16 + ontop*8 + inner*4 + gradient*2 + knockout*1];
}

static char *pshader_filter_vars[] = {
   "tex0",
   "tex1",
   "color",
   "tc_off",
   "tex2",
   "clamp0",
   "clamp1",
   "color2",
   NULL
};

static char pshader_blur_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char pshader_blur_frag1[] =
   "#define TAPS TAP(0); TAP(1);\n";
static char pshader_blur_frag2[] =
   "#define TEX0\n"
   "\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex0, 0);\n"
   "COMMON_PSCONSTANTS;\n"
   "\n"
   "BEGIN_CONSTANTS\n"
   "    DECLARE_CONST_EXTRA(HIGHP VEC4, clampv, 4);\n"
   "    #define CLAMP(t) clamp(t, clampv.xy, clampv.zw)\n"
   "    \n"
   "    DECLARE_CONST_EXTRA(MEDIUMP VEC4, tap[9], 5);\n"
   "END_CONSTANTS\n"
   "\n"
   "MAIN((ARGS))\n"
   "{\n"
   "    MEDIUMP VEC4 s = VEC4(0,0,0,0);\n"
   "    \n"
   "    #define TAP(i) s += TEX2D(tex0, CLAMP(TC0.xy + tap[i].xy)) * tap[i].z\n"
   "    TAPS\n"
   "    \n"
   "    OUTPUT(s);\n"
   "}\n";
static char pshader_blur_frag3[] =
   "#define TAPS TAP(0); TAP(1); TAP(2);\n";
static char pshader_blur_frag4[] =
   "#define TAPS TAP(0); TAP(1); TAP(2); TAP(3);\n";
static char pshader_blur_frag5[] =
   "#define TAPS TAP(0); TAP(1); TAP(2); TAP(3); TAP(4);\n";
static char pshader_blur_frag6[] =
   "#define TAPS TAP(0); TAP(1); TAP(2); TAP(3); TAP(4); TAP(5);\n";
static char pshader_blur_frag7[] =
   "#define TAPS TAP(0); TAP(1); TAP(2); TAP(3); TAP(4); TAP(5); TAP(6);\n";
static char pshader_blur_frag8[] =
   "#define TAPS TAP(0); TAP(1); TAP(2); TAP(3); TAP(4); TAP(5); TAP(6); TAP(7);\n";
static char pshader_blur_frag9[] =
   "#define TAPS TAP(0); TAP(1); TAP(2); TAP(3); TAP(4); TAP(5); TAP(6); TAP(7); TAP(8);\n";

#define NUMFRAGMENTS_pshader_blur 3
static char *pshader_blur_arr[10][NUMFRAGMENTS_pshader_blur] = {
   { NULL, NULL, NULL, },
   { NULL, NULL, NULL, },
   { pshader_blur_frag0, pshader_blur_frag1, pshader_blur_frag2, },
   { pshader_blur_frag0, pshader_blur_frag3, pshader_blur_frag2, },
   { pshader_blur_frag0, pshader_blur_frag4, pshader_blur_frag2, },
   { pshader_blur_frag0, pshader_blur_frag5, pshader_blur_frag2, },
   { pshader_blur_frag0, pshader_blur_frag6, pshader_blur_frag2, },
   { pshader_blur_frag0, pshader_blur_frag7, pshader_blur_frag2, },
   { pshader_blur_frag0, pshader_blur_frag8, pshader_blur_frag2, },
   { pshader_blur_frag0, pshader_blur_frag9, pshader_blur_frag2, },
};

static char **pshader_blur(int numtaps)
{
   return pshader_blur_arr[0 + numtaps*1];
}

static char *pshader_blur_vars[] = {
   "tex0",
   "tap",
   "clampv",
   NULL
};

static char pshader_color_matrix_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char pshader_color_matrix_frag1[] =
   "#define TEX0\n"
   "\n"
   "DECLARE_SAMPLER(LOWP SAMPLER, tex0, 0);\n"
   "COMMON_PSCONSTANTS;\n"
   "\n"
   "BEGIN_CONSTANTS\n"
   "    DECLARE_CONST_EXTRA(MEDIUMP VEC4, data[5], 4);\n"
   "END_CONSTANTS\n"
   "\n"
   "MAIN((ARGS))\n"
   "{\n"
   "    MEDIUMP VEC4 t,color;\n"
   "    t = TEX2D(tex0, TC0.xy);\n"
   "    \n"
   "#ifndef COLORMATRIX_HAS_ALPHA_EFFECTS\n"
   "    // version of colormatrix assuming no additive alpha in matrix,\n"
   "    // which is all CS3 seems to be able to output\n"
   "    color.r = dot(data[0], t) + data[4].r*t.a;\n"
   "    color.g = dot(data[1], t) + data[4].g*t.a;\n"
   "    color.b = dot(data[2], t) + data[4].b*t.a;\n"
   "    color.a = data[3].a * t.a;\n"
   "    color.rgb = color.rgb * data[3].a;\n"
   "#else\n"
   "    // version of colormatrix that matches spec   \n"
   "    if (t.a == 0.0)\n"
   "        t.rgb = VEC3(0.0);\n"
   "    else\n"
   "        t.rgb /= t.a;\n"
   "    color.r = dot(data[0], t) + data[4].r;\n"
   "    color.g = dot(data[1], t) + data[4].g;\n"
   "    color.b = dot(data[2], t) + data[4].b;\n"
   "    color.a = dot(data[3], t) + data[4].a;\n"
   "    color.rgb = color.rgb * color.a;\n"
   "#endif\n"
   "    OUTPUT(color);\n"
   "}\n";

#define NUMFRAGMENTS_pshader_color_matrix 2
static char *pshader_color_matrix_arr[1][NUMFRAGMENTS_pshader_color_matrix] = {
   { pshader_color_matrix_frag0, pshader_color_matrix_frag1, },
};

static char **pshader_color_matrix(void)
{
   return pshader_color_matrix_arr[0];
}

static char *pshader_color_matrix_vars[] = {
   "tex0",
   "data",
   NULL
};

static char pshader_manual_clear_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char pshader_manual_clear_frag1[] =
   "COMMON_PSCONSTANTS;\n"
   "\n"
   "MAIN((ARGS))\n"
   "{\n"
   "   OUTPUT(color_mul);\n"
   "}\n";

#define NUMFRAGMENTS_pshader_manual_clear 2
static char *pshader_manual_clear_arr[1][NUMFRAGMENTS_pshader_manual_clear] = {
   { pshader_manual_clear_frag0, pshader_manual_clear_frag1, },
};

static char **pshader_manual_clear(void)
{
   return pshader_manual_clear_arr[0];
}

static char *pshader_manual_clear_vars[] = {
   "color_mul",
   NULL
};

static char vshader_vsgl_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char vshader_vsgl_frag1[] =
   "#define FORMAT_V2\n";
static char vshader_vsgl_frag2[] =
   "        uniform vec4 world0;\n"
   "        uniform vec4 world1;\n"
   "        uniform vec4 x_off;\n"
   "        uniform vec4 texgen_s;\n"
   "        uniform vec4 texgen_t;\n"
   "#ifdef FLASH_10\n"
   "        uniform vec4 x3d;\n"
   "        uniform vec4 y3d;\n"
   "        uniform vec4 w3d;\n"
   "#else\n"
   "        uniform vec4 viewproj;\n"
   "#endif\n"
   "\n"
   "        attribute vec4 position;\n"
   "        attribute vec4 in_attr;\n"
   "\n"
   "        varying vec4 tex_coord;\n"
   "     \n"
   "        void main() {\n"
   "            // world transform\n"
   "            HIGHP vec4 wpos = vec4(dot(world0, position), dot(world1, position), world0.z, 1.0);\n"
   "            \n"
   "            // texture coordinates\n"
   "            tex_coord = vec4(dot(texgen_s, position), dot(texgen_t, position), 1.0, 0.0);\n"
   "        #ifdef FORMAT_V2TC2\n"
   "            tex_coord.xy = in_attr.xy;\n"
   "        #endif\n"
   "        \n"
   "            // antialias processing\n"
   "        #ifdef FORMAT_V2C4\n"
   "            HIGHP vec4 q,p;\n"
   "            HIGHP float len,newlen;\n"
   "            q.xy = in_attr.yz / 64.0;\n"
   "            len = length(q.xy);\n"
   "            p.x = q.x*x_off.x + q.y*x_off.y;\n"
   "            p.y = q.x*x_off.z + q.y*x_off.w;\n"
   "            p.z = 0.0; p.w = 0.0;\n"
   "            p.xy = vec2(dot(world0, p), dot(world1, p));\n"
   "            newlen = length(p.xy);\n"
   "            p *= (newlen!=0.0) ? len / newlen : 0.0;\n"
   "            wpos.xy += p.xy;\n"
   "            tex_coord.z = in_attr.x / 32.0;\n"
   "        #endif\n"
   "        \n"
   "            // view/projection transform\n"
   "            gl_Position = vec4(wpos.xy * viewproj.xy + viewproj.zw, wpos.zw);\n"
   "\n"
   "         #ifdef FLASH_10\n"
   "            gl_Position = wpos.x * x3d + wpos.y * y3d + w3d;  // z is ignored!\n"
   "            gl_Position.w = gl_Position.z;\n"
   "            gl_Position.z = wpos.z * gl_Position.w;\n"
   "         #endif\n"
   "        }   \n";
static char vshader_vsgl_frag3[] =
   "#define FORMAT_V2C4\n";
static char vshader_vsgl_frag4[] =
   "#define FORMAT_V2TC2\n";

#define NUMFRAGMENTS_vshader_vsgl 3
static char *vshader_vsgl_arr[3][NUMFRAGMENTS_vshader_vsgl] = {
   { vshader_vsgl_frag0, vshader_vsgl_frag1, vshader_vsgl_frag2, },
   { vshader_vsgl_frag0, vshader_vsgl_frag3, vshader_vsgl_frag2, },
   { vshader_vsgl_frag0, vshader_vsgl_frag4, vshader_vsgl_frag2, },
};

static char **vshader_vsgl(int vformat)
{
   return vshader_vsgl_arr[0 + vformat*1];
}

static char *vshader_vsgl_vars[] = {
   "world0",
   "world1",
   "x_off",
   "texgen_s",
   "texgen_t",
   "viewproj",
   NULL
};

static char vshader_vsglihud_frag0[] =
   "#version 110        // only need 100, but 110 works around a driver issue\n"
   "#define MAIN(x)     void main()\n"
   "#define ARGS\n"
   "#define ARGS2\n"
   "#define DECLARE_SAMPLER(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST(type, name, reg) uniform type name\n"
   "#define DECLARE_CONST_EXTRA(type, name, reg) uniform type name\n"
   "#define SAMPLER     sampler2D\n"
   "#define TEX2D       texture2D\n"
   "#define VEC4        vec4\n"
   "#define VEC3        vec3\n"
   "#define VEC2        vec2\n"
   "#define LOWP\n"
   "#define MEDIUMP\n"
   "#define HIGHP\n"
   "#define TC0         tex_coord.xy\n"
   "#define TC1         tex_coord.zw\n"
   "#define OUTPUT(x)   gl_FragColor = x\n"
   "\n"
   "#define SHADER_ALPHATEST(x) if (x < 0.5) discard\n"
   "\n"
   "#define COMMON_PSCONSTANTS DECLARE_CONST(VEC4, color_mul, 0); DECLARE_CONST(VEC4, color_add, 1); DECLARE_CONST(VEC4, focal, 2); varying VEC4 tex_coord\n"
   "#define COMMON_PCONSTANTS2 varying VEC4 tex_coord; varying VEC4 color_mul; varying VEC4 color_add; varying VEC4 clip_rect;\n"
   "#define BEGIN_CONSTANTS\n"
   "#define END_CONSTANTS\n"
   "\n"
   "#define saturate(x)  clamp(x,0.0,1.0)\n";
static char vshader_vsglihud_frag1[] =
   "uniform vec4 worldview[2];\n"
   "uniform vec4 material[96];\n"
   "uniform float textmode;\n"
   "\n"
   "#define pixels_per_panel_unit  1.0\n"
   "\n"
   "attribute vec2 position;\n"
   "attribute vec2 texcoord;\n"
   "attribute vec4 material_index; \n"
   "\n"
   "varying vec4 tex_coord;\n"
   "varying vec4 color_mul;\n"
   "varying vec4 color_add;\n"
   "varying vec4 clip_rect;\n"
   "\n"
   "void main() {\n"
   "    // view/projection transform\n"
   "    gl_Position = vec4(worldview[0].w + dot(worldview[0].xy, position),\n"
   "                       worldview[1].w + dot(worldview[1].xy, position),\n"
   "                       0.0,\n"
   "                       1.0);\n"
   "\n"
   "    LOWP VEC4 c1_mul,c1_add,c2_mul,c2_add, c_mul,c_add;\n"
   "    HIGHP VEC4 clip;\n"
   "\n"
   "    // convert 8-bit material_info loaded as float back to integers\n"
   "    LOWP VEC3 mat = floor(255.0*material_index.xyz + 0.5);\n"
   "\n"
   "    // @TODO: flatten these into a single array\n"
   "    c1_mul = material[int(mat.r    )];\n"
   "    c1_add = material[int(mat.r+1.0)];\n"
   "    c2_mul = material[int(mat.g    )];\n"
   "    c2_add = material[int(mat.g+1.0)];\n"
   "    clip   = material[int(mat.b    )];\n"
   "\n"
   "    // if textmode is 0, suppress c2_add.rgba\n"
   "\n"
   "    // combine hierarchical and local colors\n"
   "    color_add.rgb  = c1_mul.rgb * (c2_add.rgb * textmode) + c1_add.rgb;\n"
   "    color_mul      = c1_mul * c2_mul;\n"
   "    color_mul.a   *= material_index.w;\n"
   "\n"
   "    // compute premultiplied alpha\n"
   "    color_mul.rgb *= color_mul.a;\n"
   "    color_add.rgb *= color_mul.a;\n"
   "\n"
   "    // pass additive blending flag stored in c1_add.a and c2_add.a to pixel shader\n"
   "    color_add.a = clamp(c1_add.a + c2_add.a * textmode,0.0,1.0);\n"
   "\n"
   "    // except actually we'll premultiply that into color_mul.a\n"
   "    color_mul.a   *= (1.0-color_add.a);\n"
   "\n"
   "    // compute premultiplied cliprect\n"
   "    // for now cliprect comes in as x0,y0,x1,y1, not center/offset\n"
   "    \n"
   "    // coordinates come in already rotated into panel space, which is also where cliprect is defined\n"
   "    HIGHP VEC2 center = (clip.xy + clip.zw) / 2.0;\n"
   "    HIGHP VEC2 offset = (clip.zw - clip.xy) / 2.0;\n"
   "\n"
   "    // use of pixels_per_panel_unit here ignores effect of non-uniform scaling\n"
   "    clip_rect.xy = center * pixels_per_panel_unit;\n"
   "    clip_rect.zw = offset * pixels_per_panel_unit + 1.0; // offset is location where alpha goes to 0, so it's 1 pixel out\n"
   "\n"
   "    tex_coord.zw = position * pixels_per_panel_unit;\n"
   "    tex_coord.xy = texcoord;\n"
   "}   \n";

#define NUMFRAGMENTS_vshader_vsglihud 2
static char *vshader_vsglihud_arr[1][NUMFRAGMENTS_vshader_vsglihud] = {
   { vshader_vsglihud_frag0, vshader_vsglihud_frag1, },
};

static char **vshader_vsglihud(void)
{
   return vshader_vsglihud_arr[0];
}

static char *vshader_vsglihud_vars[] = {
   "worldview",
   "material",
   "textmode",
   NULL
};

