#pragma once

/*
AchievementGamerscore	Value in gamerscore of the achievement
AchievementID	ID of achievement unlocked
EnemyTypeID	What type of enemy or challenge was the player facing?  To prevent data-loss by overflowing the buffer, we recommend enemy type.
EnemyWeaponID	What weapon the enemy is holding or what counter/AI the enemy is taking to overcome a challenge
EnrollmentType	How did players enroll? (Using Kinect)
LandscapeOrPortrait	Are you currently showing in landscape or portrait mode? (Win8 only)
LevelDurationInSeconds	How long, total, has the user been playing in this level - whatever best represents this duration for attempting the level you'd like to track.
LevelExitProgressStat1	Refers to the highest level performance metric for your game. For example, a performance metric could points earned, race time, total kills, etc.  This is entirely up to you and will help us understand how well the player performed, or how far the player progressed in the level before exiting.
LevelExitProgressStat2	Refers to the highest level performance metric for your game. For example, a performance metric could points earned, race time, total kills, etc.  This is entirely up to you and will help us understand how well the player performed, or how far the player progressed in the level before exiting.
LevelID	This is a more granular view of mode, allowing teams to get a sense of the levels or maps players are playing and providing some insight into how players progress through a game.  Teams will have to provide the game mappings that correspond to the integers.  The intent is that a level is highest level at which modes can be dissected and provides an indication of player progression in a game.  The intent is that level start and ends do not occur more than every 2 minutes or so, otherwise the data reported will be difficult to understand.  Levels are unique only within a given modeID - so you can have a ModeID =1, LevelID =1 and a different ModeID=2, LevelID = 1 indicate two completely different levels. LevelID = 0 means undefined or unknown.
LevelInstanceID	Generated by the game every time LevelStart or LevelResume is called.  This should be a unique ID (can be sequential) within a session.
LowResMapX	Player position normalized to 0-255
LowResMapY	Player position normalized to 0-255
LowResMapZ	Player position normalized to 0-255
MapID	Unique ID for the current map the player is on
MarketplaceOfferID	Unique ID for the Xbox LIVE marketplace offer that the upsell links to
MicroGoodTypeID	Describes the type of consumable or microgood
MultiplayerInstanceID	multiplayerinstanceID is a title-generated value that is the same for all players in the same multiplayer session.
NumberOfLocalPlayers	the number of players that are playing together in the game locally in the current session (on the same piece of hardware)
NumberOfOnlinePlayers	the number of players that are playing together in the game online in the current session (not on the same piece of hardware)
NumberOfSkeletonsInView	the max and min of skeletons that were in view, regardless of enrollment
OptionalSubLevelID	Used when a title has more heirarchy required. OptionalSubLevel ID = 0 means undefined or unknown.
OptionalSubModeID	Used when a title has more heirarchy required.  OptionalSubMode ID = 0 means undefined or unknown.
PlayerLevelUpProgressStat1	Refers to a performance metric for your player when they level or rank up.  This is entirely up to you and will help us understand how well the player performed, or how far the player has progressed.
PlayerLevelUpProgressStat2	Refers to a performance metric for your player when they level or rank up.  This is entirely up to you and will help us understand how well the player performed, or how far the player has progressed.
PlayerWeaponID	What weapon the player is holding or what approach/tact the player is taking to overcome a challenge
PlayspaceFeedbackWarningDirection	identifies which side of the playspace players are getting too close to that results in the playspace feedback 
SaveOrCheckpointID	It is important that you also generate and save a unique SaveOrCheckpointID that can be read and reported when the player resumes from this save file or checkpoint.  These IDs should be completely unique across the players experience, even if they play the same level multiple times.  These IDs are critical to allowing us to re-stitch a players experience in your title and provide an accurate measure of time in level.
SecondsSinceInitialize	Number of seconds elapsed since Sentient initialize.
SecondsSinceInitializeMax	Number of seconds elapsed since Sentient initialize.
SecondsSinceInitializeMin	Number of seconds elapsed since Sentient initialize.
SkeletonDistanceInInches	Identifies the distance of the skeleton from the Kinect sensor
TitleBuildID	Build version of the title, used to track changes in development as well as patches/title updates
*/

/*
ModeID
An in-game setting that significantly differentiates the play style of the game.
(This should be captured as an integer and correspond to mode specific to the game.)
Teams will have to provide the game mappings that correspond to the integers.
The intent is to allow teams to capture data on the highest level categories of gameplay in their game.
For example, a game mode could be the name of the specific mini game (eg: golf vs darts) or a specific multiplayer mode (eg: hoard vs beast.) ModeID = 0 means undefined or unknown.
*/
enum ETelem_ModeId
{
	eTelem_ModeId_Undefined = 0,
	eTelem_ModeId_Survival,
	eTelem_ModeId_Creative, // Unused in current game version
};

/*
OptionalSubModeID
Used when a title has more heirarchy required.
OptionalSubMode ID = 0 means undefined or unknown.
*/
enum ETelem_SubModeId
{
	eTelem_SubModeId_Undefined = 0,
	eTelem_SubModeId_Normal,
	eTelem_SubModeId_Tutorial,
};

/*
LevelID
This is a more granular view of mode, allowing teams to get a sense of the levels or maps players are playing and providing some insight into how players progress through a game.
Teams will have to provide the game mappings that correspond to the integers.
The intent is that a level is highest level at which modes can be dissected and provides an indication of player progression in a game.
The intent is that level start and ends do not occur more than every 2 minutes or so, otherwise the data reported will be difficult to understand.
Levels are unique only within a given modeID - so you can have a ModeID =1, LevelID =1 and a different ModeID=2, LevelID = 1 indicate two completely different levels.
LevelID = 0 means undefined or unknown.
*/
enum ETelem_LevelId
{
	eTelem_LevelId_Undefined = 0,
	eTelem_LevelId_PlayerGeneratedLevel = 1,
	// 4J Stu - We currently do not have any specific levels (other than the tutorial which is tracked as a mode) so this is unused at the moment
};

/*
OptionalSubLevelID
Used when a title has more heirarchy required. OptionalSubLevel ID = 0 means undefined or unknown.
*/
enum ETelem_SubLevelId
{
	eTelem_SubLevelId_Undefined = 0,
	eTelem_SubLevelId_Overworld,
	eTelem_SubLevelId_Nether,
	eTelem_SubLevelId_End,
};

/*
MenuID
Describes the specific menu seen. MenuID = 0 means undefined or unknown.
*/
// 4J Stu - FOR REFERENCE ONLY - Should map 1:1 with the CConsoleMinecraftApp:EUIScene enum
// Values that are commented out here are not currently reported
enum ETelem_MenuId
{
	//eTelemMenuId_PartnernetPassword = 0,
	//eTelemMenuId_Intro = 1,
	//eTelemMenuId_SaveMessage = 2,
	//eTelemMenuId_Main = 3,
	//eTelemMenuId_FullscreenProgress = 4,
	eTelemMenuId_Pause = 5,
	//eTelemMenuId_CraftingPanel_2x2 = 6,
	//eTelemMenuId_CraftingPanel_3x3 = 7,
	//eTelemMenuId_Furnace = 8,
	//eTelemMenuId_Container = 9,
	//eTelemMenuId_Largecontainer_small = 10,// for splitscreen
	//eTelemMenuId_Inventory = 11,
	//eTelemMenuId_Trap = 12,
	//eTelemMenuId_Debug = 13,
	//eTelemMenuId_DebugTips = 14,
	//eTelemMenuId_HelpAndOptions = 15,
	eTelemMenuId_HowToPlay = 16,
	//eTelemMenuId_HowToPlayMenu = 17,
	//eTelemMenuId_Controls = 18,
	//eTelemMenuId_Settings_Menu = 19,
	//eTelemMenuId_Settings_All = 20,		
	//eTelemMenuId_Leaderboards = 21,
	//eTelemMenuId_Credits = 22,
	//eTelemMenuId_Death = 23,
	//eTelemMenuId_TutorialPopup = 24,
	eTelemMenuId_MultiGameCreate = 25,
	//eTelemMenuId_MultiGameJoinLoad = 26,
	eTelemMenuId_MultiGameInfo = 27,
	//eTelemMenuId_SignEntry = 28,
	//eTelemMenuId_InGameInfo = 29,
	//eTelemMenuId_ConnectingProgress = 30,
	eTelemMenuId_DLCOffers = 31,
	eTelemMenuId_SocialPost = 32,
	//eTelemMenuId_TrialExitUpsell = 33,
	eTelemMenuId_LoadSettings = 34,
	//eTelemMenuId_Chat = 35,
	//eTelemMenuId_Reinstall = 36,
};

/*
OptionalSubMenuID
Used when a title has more heirarchy required. OptionalSubMenuID = 0 means undefined or unknown.
*/
enum ETelemetry_HowToPlay_SubMenuId
{
	eTelemetryHowToPlay_Basics = 0,
	eTelemetryHowToPlay_HUD,
	eTelemetryHowToPlay_Inventory,
	eTelemetryHowToPlay_Chest,
	eTelemetryHowToPlay_LargeChest,
	eTelemetryHowToPlay_InventoryCrafting,
	eTelemetryHowToPlay_CraftTable,
	eTelemetryHowToPlay_Furnace,
	eTelemetryHowToPlay_Dispenser,
	eTelemetryHowToPlay_NetherPortal,
};

/*
EnemyTypeID	What type of enemy or challenge was the player facing?
To prevent data-loss by overflowing the buffer, we recommend enemy type.
*/
enum ETelemetryChallenges
{
	eTelemetryChallenges_Unknown = 0,

	eTelemetryTutorial_TrialStart,
	eTelemetryTutorial_Halfway,
	eTelemetryTutorial_Complete,

	eTelemetryTutorial_Inventory,
	eTelemetryTutorial_Crafting,
	eTelemetryTutorial_Furnace,
	eTelemetryTutorial_Fishing,
	eTelemetryTutorial_Minecart,
	eTelemetryTutorial_Boat,
	eTelemetryTutorial_Bed,

	eTelemetryTutorial_Redstone_And_Pistons,
	eTelemetryTutorial_Portal,
	eTelemetryTutorial_FoodBar,
	eTelemetryTutorial_CreativeMode,
	eTelemetryTutorial_BrewingMenu,

	eTelemetryInGame_Ride_Minecart,
	eTelemetryInGame_Ride_Boat,
	eTelemetryInGame_Ride_Pig,
	eTelemetryInGame_UseBed,

	eTelemetryTutorial_CreativeInventory, // Added TU5

	eTelemetryTutorial_EnchantingMenu,
	eTelemetryTutorial_Brewing,
	eTelemetryTutorial_Enchanting,
	eTelemetryTutorial_Farming,

	eTelemetryPlayerDeathSource_Fall,
	eTelemetryPlayerDeathSource_Lava,
	eTelemetryPlayerDeathSource_Fire,
	eTelemetryPlayerDeathSource_Water,
	eTelemetryPlayerDeathSource_Suffocate,
	eTelemetryPlayerDeathSource_OutOfWorld,
	eTelemetryPlayerDeathSource_Cactus,

	eTelemetryPlayerDeathSource_Player_Weapon,
	eTelemetryPlayerDeathSource_Player_Arrow,

	eTelemetryPlayerDeathSource_Explosion_Tnt,
	eTelemetryPlayerDeathSource_Explosion_Creeper,

	eTelemetryPlayerDeathSource_Wolf,
	eTelemetryPlayerDeathSource_Zombie,
	eTelemetryPlayerDeathSource_Skeleton,
	eTelemetryPlayerDeathSource_Spider,
	eTelemetryPlayerDeathSource_Slime,
	eTelemetryPlayerDeathSource_Ghast,
	eTelemetryPlayerDeathSource_ZombiePigman,

	eTelemetryTutorial_Breeding,
	eTelemetryTutorial_Golem,

	eTelemetryTutorial_Anvil, // Added TU14
	eTelemetryTutorial_AnvilMenu,
	eTelemetryTutorial_Trading,
	eTelemetryTutorial_TradingMenu,
	eTelemetryTutorial_Enderchest,

	// Sent over network as a byte
};